package com.ejie.ab04b.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Clase que encapsula la informacion para las excepciones controladas
 * 
 * @author GFI
 */
public class ErrorGenericoException extends RuntimeException implements Serializable {

	private static final long serialVersionUID = 1L;

	private List<ErrorField> errorsFields = null;

	// Tiles en la que mostrar el error
	private String tiles = null;

	private boolean generaTextArea = false;

	/**
	 * Constructor 'ErrorFieldsException'.
	 * 
	 *  tiles            tiles
	 *  campo            campo
	 *  mensaje            mensaje
	 *  param            param
	 *
	 * @param tiles the tiles
	 * @param campo the campo
	 * @param mensaje the mensaje
	 * @param param the param
	 */
	public ErrorGenericoException(String tiles, String campo, String mensaje, String param) {
		super("ErrorGenericoException");
		this.tiles = tiles;
		this.errorsFields = new ArrayList<ErrorField>();
		this.errorsFields.add(new ErrorField(campo, mensaje, param));
	}

	/**
	 * Constructor 'ErrorFieldsException'.
	 * 
	 *  tiles            tiles
	 *  campo            campo
	 *  mensaje            mensaje
	 *  param            param
	 *  paramIsKey            boolean
	 *
	 * @param tiles the tiles
	 * @param campo the campo
	 * @param mensaje the mensaje
	 * @param param the param
	 * @param paramIsKey the param is key
	 */
	public ErrorGenericoException(String tiles, String campo, String mensaje, String param, boolean paramIsKey) {
		super("ErrorGenericoException");
		this.tiles = tiles;
		this.errorsFields = new ArrayList<ErrorField>();
		this.errorsFields.add(new ErrorField(campo, mensaje, param, paramIsKey));
	}

	/**
	 * Constructor 'ErrorFieldsException'.
	 * 
	 *  campo            String
	 *  mensajeCode            String
	 *
	 * @param campo the campo
	 * @param mensajeCode the mensaje code
	 */
	public ErrorGenericoException(String campo, String mensajeCode) {
		super("ErrorFieldsException");
		this.errorsFields = new ArrayList<ErrorField>();
		this.errorsFields.add(new ErrorField(campo, mensajeCode));
	}

	/**
	 * Constructor 'ErrorFieldsException'.
	 * 
	 *  errorsFields            List<ErrorField>
	 *
	 * @param errorsFields the errors fields
	 */
	public ErrorGenericoException(List<ErrorField> errorsFields) {
		super("ErrorGenericoException");
		this.errorsFields = errorsFields;
	}

	/**
	 * Constructor 'ErrorFieldsException'.
	 * 
	 *  generaTextArea            boolean
	 *  errorsFields            List<ErrorField>
	 *
	 * @param generaTextArea the genera text area
	 * @param errorsFields the errors fields
	 */
	public ErrorGenericoException(boolean generaTextArea, List<ErrorField> errorsFields) {
		super("ErrorGenericoException");
		this.errorsFields = errorsFields;
		this.generaTextArea = generaTextArea;
	}

	/**
	 * Constructor a utilizar por clases hijas, para mantener la traza completa
	 * del error, mas un mensaje descriptivo que mostrar al usuario.
	 * 
	 *  mensajeCode
	 *            Codigo del literal que contiene el mensaje de error
	 *  cause
	 *            Excepcion que ha producido el error
	 *
	 * @param mensajeCode the mensaje code
	 * @param cause the cause
	 */
	public ErrorGenericoException(String mensajeCode, Throwable cause) {
		super("ErrorGenericoException", cause);
		this.errorsFields = new ArrayList<ErrorField>();
		this.errorsFields.add(new ErrorField(null, mensajeCode));
	}

	/**
	 * Constructor a utilizar para describir el mensaje de error recuperado de
	 * un servicio externo.
	 * 
	 *  mensaje            de error obtenido de un servicio externo
	 *
	 * @param mensaje the mensaje
	 */
	public ErrorGenericoException(String mensaje) {
		super(mensaje);
	}

	/**
	 * Method 'getErrorsFields'.
	 * 
	 *  List<ErrorField>
	 *
	 * @return the errors fields
	 */
	public List<ErrorField> getErrorsFields() {
		return this.errorsFields;
	}

	/**
	 * Method 'setErrorsFields'.
	 * 
	 *  errorsFields
	 *            List<ErrorField>
	 *
	 * @param errorsFields the new errors fields
	 */
	public void setErrorsFields(List<ErrorField> errorsFields) {
		this.errorsFields = errorsFields;
	}

	/**
	 * Method 'getTiles'.
	 * 
	 *  String
	 *
	 * @return the tiles
	 */
	public String getTiles() {
		return this.tiles;
	}

	/**
	 * Method 'setTiles'.
	 * 
	 *  tiles
	 *            String
	 *
	 * @param tiles the new tiles
	 */
	public void setTiles(String tiles) {
		this.tiles = tiles;
	}

	/**
	 * Method 'isGeneraTextArea'.
	 * 
	 *  boolean
	 *
	 * @return true, if is genera text area
	 */
	public boolean isGeneraTextArea() {
		return this.generaTextArea;
	}

	/**
	 * Method 'setGeneraTextArea'.
	 * 
	 *  generaTextArea
	 *            boolean
	 *
	 * @param generaTextArea the new genera text area
	 */
	public void setGeneraTextArea(boolean generaTextArea) {
		this.generaTextArea = generaTextArea;
	}
}